/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.Utilities;
import jclass.cell.renderers.CheckboxCellRenderer;

public class CheckboxEditor
extends Canvas
implements CellEditor,
KeyListener,
MouseListener {
    protected Object data;
    protected boolean currentValue;
    protected boolean editable = true;
    protected CellRenderer renderer = new CheckboxCellRenderer();
    protected CellInfo cellInfo;
    protected CellEditorSupport support = new CellEditorSupport();
    protected static final int BORDER_SIZE = 2;
    protected KeyModifier[] keys;

    public CheckboxEditor() {
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.cellInfo = cellInfo;
        this.data = object;
        this.initData();
        this.editable = cellInfo.isEditable();
        if (initialEvent.getEventType() == 1) {
            this.toggleValue();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.cellInfo.isEditable() ? this.cellInfo.getBackground().brighter() : this.cellInfo.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n = this.cellInfo.getMarginInsets().left + this.cellInfo.getBorderInsets().left;
        int n2 = this.cellInfo.getMarginInsets().top + this.cellInfo.getBorderInsets().top;
        graphics.translate(n, n2);
        this.renderer.draw(graphics, this.cellInfo, this.getCellEditorValue(), false);
        graphics.translate(-n, -n2);
        Utilities.drawBorder(graphics, 8, 2, 0, 0, rectangle.width, rectangle.height, Color.black, Color.white);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Object getCellEditorValue() {
        return new Boolean(this.currentValue);
    }

    public Component getComponent() {
        return this;
    }

    public boolean isModified() {
        return (Boolean)this.data != this.currentValue;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
        this.initData();
        this.repaint();
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        Rectangle rectangle = cellInfo.getDrawingArea();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public KeyModifier[] getReservedKeys() {
        return this.keys;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    void initData() {
        this.currentValue = (Boolean)this.data;
    }

    void toggleValue() {
        if (this.editable) {
            this.currentValue = !this.currentValue;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                return;
            }
            case 27: {
                this.support.fireCancelEditing(new CellEditorEvent(keyEvent));
                return;
            }
            case 32: {
                this.toggleValue();
                this.repaint();
                return;
            }
        }
        if (!keyEvent.isActionKey() && Character.isLetterOrDigit(keyEvent.getKeyChar())) {
            this.toggleValue();
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.toggleValue();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

